﻿
########################## BY PEWA 2303 #######################################

######################### https://sid-500.com ################################# 


######## Kopiert alle Eigenschaften eines bestehenden Benutzers ###############
##################  und legt die Exchange Mailbox an   ########################


###################### Import ActiveDirectory #################################


Import-Module ActiveDirectory


###############################################################################

Clear-host


############### Check, ob der zu kopierende User existiert ####################

	do {
$nameds = Read-Host "Von welchem Benutzer sollen die Informationen kopiert werden? (Format z.B.: m.mustermann)"
if (dsquery user -samid $nameds){Write-host -foregroundcolor Green "AD User gefunden!" 
}

elseif ($nameds = "null") {Write-Host -foregroundcolor Red "AD User nicht gefunden!, Probieren Sie mmustermann oder mustermann"}
}
while ($nameds -eq "null")
	
		
################ Alle Infos vom bestehenden User abrufen ######################

$name = Get-AdUser -Identity $nameds -Properties *

$DN = $name.distinguishedName
$OldUser = [ADSI]"LDAP://$DN"
$Parent = $OldUser.Parent
$OU = [ADSI]$Parent
$OUDN = $OU.distinguishedName
$NewUser = Read-Host "Anmeldename des neuen Benutzers (Format: v.nachname)"
$firstname = Read-Host "Vorname"
$Lastname = Read-Host "Nachname"
$NewName = "$firstname $lastname"
$domain = [System.DirectoryServices.ActiveDirectory.Domain]::GetCurrentDomain() 
$prof = $name.ProfilePath


#################### Neuen Benutzer erstellen ##################################


New-ADUser -SamAccountName $NewUser -Name $NewName -GivenName $firstname -displayname "$firstname $lastname" -Surname $lastname -Instance $DN -Path "$OUDN" -AccountPassword (Read-Host "New Password" -AsSecureString) –userPrincipalName $NewUser@$domain -Company $name.Company -Department $name.Department -Manager $name.Manager -title $name.Title -Office $name.Office -City $name.city -PostalCode $name.postalcode -Country $name.country -Fax $name.fax -State $name.State -StreetAddress $name.StreetAddress -Enabled $true -ProfilePath ($prof -replace $name.SamAccountName, $NewUser) -HomePage $name.wWWHomePage -ScriptPath $name.ScriptPath
Set-ADUser -identity $newUser -ChangePasswordAtLogon $true


#################### Gruppenmitgliedschaften kopieren ###########################

write-host "Bitte Warten ... Kopieren der Gruppenmitgliedschaften ..."

$groups = (GET-ADUSER –Identity $name –Properties MemberOf).MemberOf
foreach ($group in $groups) { 

Add-ADGroupMember -Identity $group -Members $NewUser
}
$count = $groups.count

################### Auswahl der Exchange Datenbank  #############################

Write-host "1- DB1"
Write-host "2- DB2"
Write-host "3- DB3"
Write-host "4- DB4"
Write-host "5- DB5"
Write-host "6- DB6"
Write-host "7- DB7"
Write-host "8- DB8"
$db = read-host "In welcher Exchange Datenbank soll der Benutzer angelegt werden 1-8 ?"

switch ($db) 
    { 
        1 {$db = "DB1"} 
        2 {$db = "DB2"} 
        3 {$db = "DB3"} 
        4 {$db = "DB4"}
        5 {$db = "DB5"}
        6 {$db = "DB6"}
        7 {$db = "DB7"}
        8 {$db = "DB8"}

        default {$db = "DB1"}
    }



################## Wartezeit für die Erstellung der Mailbox #########################


write-host "Bitte Warten ... die Mailbox wird angelegt ..."

Start-Sleep -s 5

$Session = New-PSSession -ConfigurationName Microsoft.Exchange -ConnectionUri http://Einsetzen/PowerShell/ -Authentication Kerberos -ErrorAction SilentlyContinue -WarningAction SilentlyContinue
import-pssession $Session -ErrorAction SilentlyContinue -WarningAction SilentlyContinue



#################### Neue Mailbox wird erstellt #####################################


Enable-Mailbox -Identity $Newuser -alias $newuser -Database "$db" -ErrorAction silentlycontinue -WarningAction silentlycontinue

Clear-Host

$final1=get-aduser -identity $newuser -properties * | fl Displayname,CanonicalName,Department,Profilepath,ScriptPath,whenCreated

$final3=get-mailbox -identity $newuser

Start-Sleep -s 5

Write-Host "Folgender Benutzer wurde erfolgreich in Active Directory und Exchange angelegt:"

$final1

$final3

$final2=Get-ADPrincipalGroupMembership -Identity $newuser | fl Name
""
""

Write-Host "Der Benutzer ist Mitglied folgender Gruppen:"
""
$final2
""
""
Write-Host -ForegroundColor Green "Das Skript wurde erfolgreich ausgeführt"

$finalall=$final1+$final2+$final3


PAUSE