﻿######################### BY PEWA2303 ################################

###################### Import ActiveDirectory ########################

Import-Module ActiveDirectory

######################################################################

Clear-host

### Zu löschenden User abrufen ###

do {
 $a=Read-Host "Name des Mitarbeiters, welcher deaktiviert werden soll (Im Format z.B.: m.mustermann}?"
 if (dsquery user -samid $a){Write-host -foregroundcolor Green "AD User gefunden!"
 }

elseif ($a = "null") {Write-Host -foregroundcolor Red "AD User nicht gefunden!"}
 }
 while ($a -eq "null")

### Deaktivieren des Active Directory Accounts ###

get-aduser -identity "$a" | set-aduser -Enabled $false

Write-Host -foregroundcolor Green "Der Benutzer wurde deaktiviert!"

### Verschieben des Account in die OU deaktiverte User ###

get-aduser -identity "$a" | Move-ADObject -TargetPath "OU=Einsetzen,DC=Einsetzen,DC=Einsetzen"

Write-Host -foregroundcolor Green "Der Benutzer wurde in die OU "deaktivierte User" verschoben"

### Entfernen von allen Gruppen, außer von Domain Users (nicht möglich) ###

$ADgroups = Get-ADPrincipalGroupMembership -Identity "$a" | where {$_.Name -ne "Domänen-Benutzer"}

If ($ADgroups -ne $null) {Remove-ADPrincipalGroupMembership -Identity "$a" -MemberOf $ADgroups -Confirm:$false -WarningAction SilentlyContinue -ErrorAction Ignore
 }
### Import Exchange Session ###

$Session = New-PSSession -ConfigurationName Microsoft.Exchange -ConnectionUri http://Einsetzen Names des Exchange Servers/PowerShell/ -Authentication Kerberos -ErrorAction SilentlyContinue -WarningAction SilentlyContinue
import-pssession $Session -WarningAction SilentlyContinue -erroraction ignore -allowclobber

### Entfernen vom Adressbuch und der E-Mail Richtlinie ###

get-mailbox -identity $a | set-mailbox -HiddenFromAddressListsEnabled $true -EmailAddressPolicyEnabled $false

### Random Wert erzeugen ###

$b=$a+(get-random -Maximum 100)

### Entfernen aller E-Mail Adressen ###

Set-Mailbox -identity $a -EmailAddresses SMTP:$b@Einsetzen Domäne.at

### Auflisten der neuen Attribute des Benutzers"

clear-host

Write-Host "Bitte überprüfen Sie die Angaben:"

Write-Host "User deaktiviert:"

get-aduser -identity $a -properties * | fl Displayname,Enabled

Write-Host "Gruppenmitgliedschaften:"

Get-ADPrincipalGroupMembership -Identity $a | fl Name

Write-Host "E-Mail Adressen:"

Get-Mailbox -Identity $a | fl EmailAddresses

PAUSE