$dcs=(Get-ADDomainController -Filter *).Name
foreach ($item in $dcs) {
 Try
 {
 Test-Connection $item -Count 1 -ErrorAction Stop | Out-Null
 }
 Catch
 {
 $Site=(Get-ADDomainController $item).Site
 $IP= (Get-ADDomainController $item).IPv4Address
 $date=Get-Date -Format F
 Send-MailMessage -From Alert@domain.com -To p.gruenauer@domain.com -SmtpServer EX01 -Subject "Site: $Site | $item is down" -Body "$IP could not be reached at $date.`n`nIf you receive this message again in 15 minutes, $item is probably down."
}
}