<#
.Synopsis
   This function generates ramdom passwords.
.DESCRIPTION
   Generate-Password generates a randomly generated password. 
   An account name for the password reference can also be specified. 
   Both will be stored to the clipboard. 
.PARAMETER
   -Account
   Enter the account for this password.
   -Length 
   Enter the length of the password. Standard: 12
.EXAMPLE (Simple)
   Generate-Password 
.EXAMPLE (Advanced)
   Generate-Password -Account yourname@domain.com -Length 14
.NOTES
   Patrick Gruenauer | sid-500.com
   Microsoft PowerShell MVP
#>


function Generate-Password {

[CmdletBinding()]
 
param
( 
[Parameter()]
$Account = '"No account specified."',
 
[Parameter()]
$Length = '12'
)
Clear-Host
$alphabetu = [char[]](65..90)
$alphabetl = [char[]](97..122)
$character = '+#()%$:,?!&'.ToCharArray()
$digits    = 1..10

$password = ($alphabetu,$alphabetl,$character,$digits | 
Get-Random -Count $Length) -join ''

$null | Set-Clipboard
$account | Set-Clipboard
$password | Set-Clipboard -Append

Write-Output "Your $length charachter password for account $account :`n$password"
Write-Warning "Account Name and Password saved to clipboard."

}